



<html>
<head>
  <title>javabog.dk -  - Grafiske standardkomponenter</title>
  <link rev="stylesheet" type="text/css" href="../typografi.css">
  <meta name="description" content="Lrebog i Java. Af Jacob Nordfalk. Udkommet hos Forlaget Globe">
  <meta name="keywords" content="designmnster, programmering, OOP, objekter, klasser, objektorienteret programmering, Java, JSP, lrebog, UML, IT">
</head>
<body bgcolor="#ffffff">



<a href='http://javabog.dk/'>javabog.dk</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel10.jsp'>&lt;&lt; forrige</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='indhold.jsp'>indhold</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel12.jsp'>n&aelig;ste &gt;&gt;</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kode/'>programeksempler</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='../index_OOP.html'>om bogen</a>

<H1 CLASS="western" STYLE="">11 <a name='afsn11'></a>Grafiske
standardkomponenter</H1>
<P CLASS="kapiteloversigt-western">Indhold:</P>
<UL>
  <LI><P CLASS="kapiteloversigt-western">Design af en grafisk
  brugergr&aelig;nseflade med et udviklingsv&aelig;rkt&oslash;j</P>
  <LI><P CLASS="kapiteloversigt-western">De vigtigste grafiske
  komponenter og deres egenskaber</P>
  <LI><P CLASS="kapiteloversigt-western">Containere og layout-managere</P>
  <LI><P CLASS="kapiteloversigt-western">Menuer</P>
</UL>
<P CLASS="kapiteloversigt-western">Foruds&aelig;ttes af <a href='kapitel13.jsp'>kapitel 13</a>,
H&aelig;ndelser.</P>
<P CLASS="kapiteloversigt-western">Kapitlet foruds&aelig;tter <a href='kapitel9.jsp'>kapitel
9</a>, Grafiske programmer, og at du har adgang til et v&aelig;rkt&oslash;j,
der kan udvikle grafiske brugergr&aelig;nseflader (f.eks. Borland
JBuilder, Oracle JDeveloper, Netbeans eller Eclipse). 
</P>

<P CLASS="western" STYLE="">N&aring;r man
skal lave en grafisk brugergr&aelig;nseflade (eng.: GUI, graphical
user interface), g&oslash;res det ofte ved at anvende
standardkomponenter. Vi vil starte med at se p&aring;, hvordan
det g&oslash;res i praksis med et v&aelig;rkt&oslash;j.</P>
<H2 CLASS="western">11.1 <a name='afsn11.1'></a>Generering med et v&aelig;rkt&oslash;j</SPAN></H2>
<P CLASS="western">Med moderne udviklingsv&aelig;rkt&oslash;jer kan
man udarbejde en grafisk brugergr&aelig;nseflade ud fra
standardkomponenter p&aring; ret kort tid og uden at skulle
programmere ret meget selv.</P>
<P CLASS="western">Herunder er beskrevet, hvordan man g&oslash;r i
Borland JBuilder, med sidel&oslash;bende forklaringer til
udviklingsv&aelig;rkt&oslash;jerne Oracle JDeveloper og Netbeans.
Hvis du bruger et andet v&aelig;rkt&oslash;j, m&aring; du pr&oslash;ve
dig lidt frem. Ideerne er de samme og koden, der genereres, ligner
ogs&aring; nogenlunde, men menuerne og knapperne varierer
selvf&oslash;lgelig noget.</P>
<P CLASS="western" ALIGN=CENTER><IMG SRC="bog12_html_78ea31fe.gif" NAME="Objekt20"></P>
<P CLASS="western">I JBuilder/JDeveloper er det nemmest at tage en
eksisterende klasse, der arver fra Frame eller Applet, f.eks.
GrafiskVindue fra <a href='kapitel9.jsp'>kapitel 9</a> (i Netbeans skal du oprette ny &quot;GUI
Form&quot;) .</P>
<P CLASS="western">Hvis du i stedet vil oprette en ny, s&aring; v&aelig;lg
'New..' og Application eller Applet. Fjern pakkenavnet, skriv et navn
p&aring; din klasse og klik 'Finish'. Defin&eacute;r evt. en
paint()-metode, der tegner noget. I Netbeans/andre: Opret en ny frame
eller applet.</P>
<OL>
  <LI><P CLASS="western">G&aring; over p&aring; Design-fanen (ved
  punkt 1 nederst). Den er delt op i en del, hvor du designer din
  brugergr&aelig;nseflade til venstre og en tabel af egenskaber til
  h&oslash;jre (punkt 2).<BR>JDeveloper: H&oslash;jreklik p&aring;
  GrafiskVindue.java og v&aelig;lg 'UI Editor'.<BR>Netbeans: G&aring;
  over p&aring; fanen 'GUI Editing', hvis du ikke allerede st&aring;r
  der.</P>
  <LI><P CLASS="western">Her skal du f&oslash;rst &aelig;ndre layout
  fra '&lt;default layout&gt;' til 'null' (punkt 2 til h&oslash;jre;
  m&aring;ske skal du klikke p&aring; den gr&aring; flade i designeren
  f&oslash;rst).<BR>Netbeans: H&oslash;jreklik p&aring; den gr&aring;
  flade og v&aelig;lg 'Set Layout' og 'Null layout'.</P>
  <LI><P CLASS="western">Nu kan du g&aring; i gang med at l&aelig;gge
  komponenter ind p&aring; gr&aelig;nsefladen. <BR>V&aelig;lg i f&oslash;rste
  omgang at arbejde med AWT-komponenter (punkt 3).</P>
  <LI><P CLASS="western">V&aelig;lg f&oslash;rst en Label (det store A
  ved punkt 4) og klik p&aring; gr&aelig;nsefladen. Der dukker en
  etikette med en tekst op. P&aring; egenskabstabellen til h&oslash;jre
  kan du &aelig;ndre dens variabelnavn (<SPAN STYLE="font-weight: medium"><I>name</I></SPAN>
  &oslash;verst) til f.eks. labelHvadErDitNavn. L&aelig;ngere nede er
  egenskaben <SPAN STYLE="font-weight: medium"><I>text</I></SPAN>, der
  bestemmer, hvad der skal st&aring; p&aring; etiketten. Ret den til
  f.eks. &quot;Hvad er dit navn?&quot;.</P>
  <LI><P CLASS="western">Inds&aelig;t derefter et TextField (et
  indtastningsfelt - l&aelig;ngere nede i listen). <BR>Ret
  variabelnavnet til textFieldNavn og teksten til f.eks. &quot;Jacob&quot;.</P>
</OL>
<P CLASS="western">G&aring; tilbage til Source-fanen. Nu ser
kildeteksten nogenlunde s&aring;ledes ud:</P>
<PRE CLASS="ikke-javakode-western">import java.awt.*;

public class GrafiskVindue extends Frame
{
  <B>Label labelHvadErDitNavn = new Label()</B>;
  <B>TextField textFieldNavn = new TextField()</B>;

  public void paint(Graphics g)
  {
<I>    // Herunder referer g til et Graphics-objekt man kan tegne med.</I>
    g.drawLine(0,0,50,50);

    g.fillOval(5,20,300,30);

    g.setColor(Color.GREEN);

    g.drawString(&quot;Hej grafiske verden!&quot;,100,40);
  }

  public GrafiskVindue() {
    try {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }

  private void jbInit() throws Exception {
    <B>labelHvadErDitNavn.setText(&quot;Hvad er dit navn?&quot;)</B>;
    labelHvadErDitNavn.setBounds(new Rectangle(15, 69, 108, 15));
    <B>textFieldNavn.setText(&quot;Jacob&quot;)</B>;
    textFieldNavn.setBounds(new Rectangle(141, 61, 112, 29));
    this.setLayout(null);
    this.add(textFieldNavn, null);
    this.add(labelHvadErDitNavn, null);
  }
}</PRE><P CLASS="western">
De to objekter, vi satte p&aring; i designeren, er erkl&aelig;ret og
oprettet &oslash;verst uden for metoderne:</P>
<PRE CLASS="kode-western">  Label labelHvadErDitNavn = new Label();
  TextField textFieldNavn = new TextField();</PRE><P CLASS="western">
Nedenunder st&aring;r vores gamle paint() u&aelig;ndret. Herunder er
der oprettet en konstrukt&oslash;r, der kalder metoden jbInit(). I
Netbeans hedder metoden initComponents(). 
</P>
<P CLASS="western">Den andet kode, 'try{ ... } catch (Exception e)
{...}' er beregnet til at h&aring;ndtere undtagelser og vil blive
forklaret i <a href='kapitel14.jsp'>kapitel 14</a>, Undtagelser.</P>
<P CLASS="western">I metoden jbInit() nedenunder l&aelig;gger
v&aelig;rkt&oslash;jet koden til at initialisere de grafiske
komponenter. Man ser her, hvordan b&aring;de Label og TextField har
metoden setText() og at begge objekter f&aring;r kaldt denne metode
(svarende til, at vi &aelig;ndrede egenskaben <SPAN STYLE="font-weight: medium"><I>text</I></SPAN>).</P>
<PRE CLASS="kode-western">    labelHvadErDitNavn.setText(&quot;Hvad er dit navn?&quot;);
    textFieldNavn.setText(&quot;Jacob&quot;);</PRE><P CLASS="western">
De andre kommandoer i jbInit() s&oslash;rger for at placere
komponenterne korrekt i vinduet.</P>

<P CLASS="western">&quot;Design&quot;- og &quot;Source&quot;-fanen er
to m&aring;der at se programmet p&aring; og man kan frit skifte
mellem dem. Laver man en design&aelig;ndring, vil det blive afspejlet
i koden i jbInit(). &AElig;ndrer man i koden, vil designet &aelig;ndre
sig (i Netbeans er koden beskyttet mod &aelig;ndringer). Tilf&oslash;jer
du din egen kode til denne metode, s&aring; s&oslash;rg for, at det
ligner v&aelig;rkt&oslash;jets egen kode, ellers kan v&aelig;rkt&oslash;jet
have sv&aelig;rt ved at opretholde sammenh&aelig;ngen mellem kode og
design.</P>
<H3 CLASS="western">11.1.1 <a name='afsn11.1.1'></a>Interaktive programmer</H3>
<P CLASS="western">Lad os nu tilf&oslash;je en knap og et
indtastningsfelt p&aring; flere linjer (TextArea). Jeg kalder dem for
buttonOpdater og textAreaHilsen. Knappen skal selvf&oslash;lgelig
g&oslash;re noget. Fra Design-fanen, dobbeltklik p&aring; knappen, og
vupti! Der genereres automatisk en metode til at h&aring;ndtere
et klik (og pakken java.awt.event bliver importeret):</P>
<PRE CLASS="kode-western">  void buttonOpdater_actionPerformed(ActionEvent e) {

  }</PRE><P CLASS="western">
Hvis du kigger i jbInit(), kan du se, at JBuilder har indsat f&oslash;lgende
kode:</P>
<PRE CLASS="kode-western">    buttonOpdater.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        buttonOpdater_actionPerformed(e);
      }
    });</PRE><P CLASS="western">
Det er disse linjer, der s&oslash;rger for at &quot;lytte efter
h&aelig;ndelser&quot; p&aring; knappen, s&aring;dan at n&aring;r man
klikker p&aring; buttonOpdater, s&aring; kaldes metoden
buttonOpdater_actionPerformed(). Det vil vi komme tilbage til i
<a href='kapitel13.jsp'>kapitel 13</a>, H&aelig;ndelser.</P>
<P CLASS="western">Nu kan du inds&aelig;tte kode, der udf&oslash;rer
en handling. Skriv f.eks. noget ud til systemoutput: 
</P>
<PRE CLASS="kode-western">  void buttonOpdater_actionPerformed(ActionEvent e) {
    System.out.println(&quot;Opdater!&quot;);
  }</PRE><P CLASS="western">
Vi kunne ogs&aring; lave noget sjovere, f.eks. l&aelig;se den
indtastede tekst fra textFieldNavn og skrive den i textAreaHilsen.
JBuilder har lavet koden, der s&aelig;tter teksterne for os og ved at
studere den kan man f&aring; en ide til, hvordan det skal g&oslash;res:</P>
<PRE CLASS="kode-western">    String navn = textFieldNavn.getText();     // afl&aelig;s navnet

    textAreaHilsen.setText(&quot;Hej k&aelig;re &quot;+navn);  // s&aelig;t navnet</PRE>
<P CLASS="western">Her har vi tastet &quot;Jacob Nordfalk&quot; ind
og trykket p&aring; &quot;opdater!&quot;-knappen (paint() er &aelig;ndret
til ogs&aring; at tegne navnet 5 gange).</P>
<P ALIGN=CENTER STYLE="margin-top: 0.11cm; margin-bottom: 0.11cm"><IMG SRC="bog12_html_19b7d71c.png" NAME="Grafik14" ALIGN=BOTTOM BORDER=0></P>
<P CLASS="western">Der er alts&aring; to m&aring;der at arbejde med
grafik p&aring;: 
</P>
<UL>
  <LI><P CLASS="western">I paint() tegner man &quot;i h&aring;nden&quot;
  ved at give kommandoer til et Graphics-objekt.</P>
  <LI><P CLASS="western">Ved at bruge de grafiske standardkomponenter.</P>
</UL>


<P CLASS="western" STYLE="">Her kommer det
fulde eksempel. 
</P>
<PRE CLASS="kode-western">import java.awt.*;
import java.awt.event.*;

public class GrafiskVindue extends Frame
{
  Label labelHvadErDitNavn = new Label();
  TextField textFieldNavn = new TextField();
<B>  Button buttonOpdater = new Button();</B>
<B>  TextArea textAreaHilsen = new TextArea();</B>

  public void paint(Graphics g)
  {
<I>    g.drawLine(0,0,50,50);</I>
    g.fillOval(5,20,300,30);

    g.setColor(Color.GREEN);
    String navn = textFieldNavn.getText();
    for (int i=0; i&lt;50; i=i+10)
      g.drawString(&quot;Hej &quot;+navn+&quot; !&quot;,100+i,30+i);
  }


<I>  // Udviklingsv&aelig;rkt&oslash;j definerer gerne en separat metode hvor de </I>
<I>  // initialiserer komponenterne. I JBuilder og JDeveloper hedder</I>
<I>  // den jbInit(), mens den hedder initComponents() i Betbeans.</I>
<I>  // Initialiseringen kunne dog lige s&aring; godt ligge direkte her i konstrukt&oslash;ren</I>

  public GrafiskVindue() {
    try {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }


<I>  // Udviklingsv&aelig;rkt&oslash;jets initialisering af komponenter.</I>
<I>  // &AElig;ndr med varsomhed, ellers kan v&aelig;rkt&oslash;jet ikke genkende &quot;sin&quot; kode.</I>

  private void jbInit() throws Exception {
    labelHvadErDitNavn.setText(&quot;Hvad er dit navn?&quot;);
    labelHvadErDitNavn.setBounds(new Rectangle(15, 69, 108, 15));
    textFieldNavn.setText(&quot;Jacob&quot;);
    textFieldNavn.setBounds(new Rectangle(129, 61, 95, 29));
<B>    buttonOpdater.setLabel(&quot;opdater!&quot;);</B>
    buttonOpdater.setBounds(new Rectangle(231, 60, 91, 32));
    buttonOpdater.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        buttonOpdater_actionPerformed(e);
      }
    });
<B>    textAreaHilsen.setText(&quot;Her kommer en tekst...&quot;);</B>
    textAreaHilsen.setBounds(new Rectangle(6, 102, 316, 78));
    this.setLayout(null);
    this.add(labelHvadErDitNavn, null);
    this.add(textAreaHilsen, null);
    this.add(buttonOpdater, null);
    this.add(textFieldNavn, null);
  }

  void buttonOpdater_actionPerformed(ActionEvent e) {
<B>    String navn = textFieldNavn.getText();</B>
    System.out.println(&quot;Opdater! navn=&quot;+navn);
<B>    textAreaHilsen.setText(&quot;Hej k&aelig;re &quot;+navn);</B>
<B>    repaint();</B><SPAN STYLE="font-weight: medium"><I> // gentegn vinduet</I></SPAN>
  }
}</PRE>
<H2 CLASS="western" STYLE="">11.2 <a name='afsn11.2'></a>Grafiske
komponenter</SPAN></H2>
<P CLASS="western">Grafiske komponenter er objekter, der bruges som
en synlig del af en grafisk brugergr&aelig;nseflade, f.eks.
knapper, valglister, indtastningsfelter, etiketter.</P>
<P CLASS="western">Alle komponenter arver fra Component-klassen og
har derfor dennes tr&aelig;k til f&aelig;lles:</P>
<P CLASS="western">Metoderne setForeground(Color c) og
setBackground(Color c) s&aelig;tter hhv. forgrundsfarven og
baggrundsfarven for komponenten, svarende til egenskaberne <I>foreground</I>
og <I>background</I>. Egenskaberne kan afl&aelig;ses med
getForeground() og getBackground().</P>
<P CLASS="western">En anden egenskab er <I>font</I>, der bestemmer
skrifttypen. I tr&aring;d med de andre egenskaber s&aelig;ttes den
med setFont(Font f) og afl&aelig;ses med getFont().</P>
<P CLASS="western">Dette kan sammenfattes i en tabel over egenskaber,
der er f&aelig;lles for alle komponenter.</P>
<TABLE BORDER=0 CELLPADDING=2 CELLSPACING=0>
  <COL*>
  <COL*>
  <COL*>
  <COL*>
  <THEAD>
    <TR VALIGN=TOP>
      <TH>
        <P CLASS="western">Egenskab</P>
      </TH>
      <TH>
        <P CLASS="western">Type</P>
      </TH>
      <TH>
        <P CLASS="western">S&aelig;ttes med</P>
      </TH>
      <TH>
        <P CLASS="western">L&aelig;ses med</P>
      </TH>
    </TR>
  </THEAD>
  <TBODY>
    <TR VALIGN=TOP>
      <TD>
        <P CLASS="western">foreground</P>
      </TD>
      <TD>
        <P CLASS="western">Color</P>
      </TD>
      <TD>
        <P CLASS="western">setForeground(Color c)</P>
      </TD>
      <TD>
        <P CLASS="western">getForeground()</P>
      </TD>
    </TR>
    <TR VALIGN=TOP>
      <TD>
        <P CLASS="western">background</P>
      </TD>
      <TD>
        <P CLASS="western">Color</P>
      </TD>
      <TD>
        <P CLASS="western">setBackground(Color c)</P>
      </TD>
      <TD>
        <P CLASS="western">getBackground()</P>
      </TD>
    </TR>
    <TR VALIGN=TOP>
      <TD>
        <P CLASS="western">font</P>
      </TD>
      <TD>
        <P CLASS="western">Font</P>
      </TD>
      <TD>
        <P CLASS="western">setFont(Font f)</P>
      </TD>
      <TD>
        <P CLASS="western">getFont()</P>
      </TD>
    </TR>
    <TR VALIGN=TOP>
      <TD>
        <P CLASS="western">visible</P>
      </TD>
      <TD>
        <P CLASS="western">boolean</P>
      </TD>
      <TD>
        <P CLASS="western">setVisible(boolean synlig)</P>
      </TD>
      <TD>
        <P CLASS="western">isVisible()</P>
      </TD>
    </TR>
  </TBODY>
</TABLE>
<P CLASS="western">Nedenfor vil de mest almindelige komponenter blive
beskrevet. Kun de nye egenskaber er beskrevet.</P>
<H3 CLASS="western">11.2.1 <a name='afsn11.2.1'></a>Button</H3>
<P CLASS="western"><IMG SRC="bog12_html_m7d8ec057.png" NAME="Grafik5" ALIGN=LEFT BORDER=0><BR CLEAR=LEFT>En
trykknap. Egenskaben <I>label</I> angiver, hvad der st&aring;r p&aring;
knappen.</P>
<TABLE BORDER=0 CELLPADDING=2 CELLSPACING=0>
  <COL*>
  <COL*>
  <COL*>
  <COL*>
  <THEAD>
    <TR VALIGN=TOP>
      <TH>
        <P CLASS="western">Egenskab</P>
      </TH>
      <TH>
        <P CLASS="western">Type</P>
      </TH>
      <TH>
        <P CLASS="western">S&aelig;ttes med</P>
      </TH>
      <TH>
        <P CLASS="western">L&aelig;ses med</P>
      </TH>
    </TR>
  </THEAD>
  <TBODY>
    <TR VALIGN=TOP>
      <TD>
        <P CLASS="western">label</P>
      </TD>
      <TD>
        <P CLASS="western">String</P>
      </TD>
      <TD>
        <P CLASS="western">setLabel(String t)</P>
      </TD>
      <TD>
        <P CLASS="western">getLabel()</P>
      </TD>
    </TR>
  </TBODY>
</TABLE>
<H3 CLASS="western">11.2.2 <a name='afsn11.2.2'></a>Checkbox</H3>
<P CLASS="western"><IMG SRC="bog12_html_7ef0df10.png" NAME="Grafik6" ALIGN=LEFT BORDER=0><BR CLEAR=LEFT>Et
afkrydsningsfelt. Kan b&aring;de bruges til flueben og til
radioknapper. Hvis man skal have radioknapper (der gensidigt
udelukker hinanden), skal objekterne knyttes sammen af et
CheckboxGroup-objekt.</P>
<P CLASS="western"><I>label</I> angiver, hvad der st&aring;r ved
feltet. <I>state</I> angiver, om feltet er afkrydset.</P>
<TABLE BORDER=0 CELLPADDING=2 CELLSPACING=0>
  <COL*>
  <COL*>
  <COL*>
  <COL*>
  <THEAD>
    <TR VALIGN=TOP>
      <TH>
        <P CLASS="western">Egenskab</P>
      </TH>
      <TH>
        <P CLASS="western">Type</P>
      </TH>
      <TH>
        <P CLASS="western">S&aelig;ttes med</P>
      </TH>
      <TH>
        <P CLASS="western">L&aelig;ses med</P>
      </TH>
    </TR>
  </THEAD>
  <TBODY>
    <TR VALIGN=TOP>
      <TD>
        <P CLASS="western">label</P>
      </TD>
      <TD>
        <P CLASS="western">String</P>
      </TD>
      <TD>
        <P CLASS="western">setLabel(String t)</P>
      </TD>
      <TD>
        <P CLASS="western">getLabel()</P>
      </TD>
    </TR>
    <TR VALIGN=TOP>
      <TD>
        <P CLASS="western">state</P>
      </TD>
      <TD>
        <P CLASS="western">boolean</P>
      </TD>
      <TD>
        <P CLASS="western">setState (boolean afkrydset)</P>
      </TD>
      <TD>
        <P CLASS="western">getState()</P>
      </TD>
    </TR>
  </TBODY>
</TABLE>
<H3 CLASS="western">11.2.3 <a name='afsn11.2.3'></a>Choice</H3>
<P CLASS="western"><IMG SRC="bog12_html_mf37ea0b.png" NAME="Grafik4" ALIGN=LEFT BORDER=0><BR CLEAR=LEFT>En
valgliste. Brug metoden addItem(String elementnavn) til at tilf&oslash;je
indgange. 
</P>
<P CLASS="western">Med getSelectedItem() unders&oslash;ger man, hvad
brugeren har valgt.</P>

<H3 CLASS="western" STYLE="">11.2.4 <a name='afsn11.2.4'></a>TextField</H3>
<P CLASS="western"><IMG SRC="bog12_html_m29d515ac.png" NAME="Grafik20" ALIGN=LEFT BORDER=0><BR CLEAR=LEFT>Et
indtastningsfelt p&aring; en linje. Egenskaben <I>text</I> angiver,
hvad der st&aring;r i feltet. 
</P>
<P CLASS="western">Mindre brugt er: <I>columns</I> angiver, hvor
bredt feltet skal v&aelig;re.</P>
<P CLASS="western"><I>editable</I> angiver, om brugeren kan redigere
teksten i indtastningsfeltet.</P>
<P CLASS="western"><I>echoChar</I> bruges til felter, der skal skjule
det indtastede, typisk adgangskoder. 
</P>
<P CLASS="western">S&aelig;t f.eks. <I>echoChar</I> til '*' for at f&aring;
vist stjerner i stedet for det indtastede.</P>
<TABLE BORDER=0 CELLPADDING=2 CELLSPACING=0>
  <COL*>
  <COL*>
  <COL*>
  <COL*>
  <THEAD>
    <TR VALIGN=TOP>
      <TH>
        <P CLASS="western">Egenskab</P>
      </TH>
      <TH>
        <P CLASS="western">Type</P>
      </TH>
      <TH>
        <P CLASS="western">S&aelig;ttes med</P>
      </TH>
      <TH>
        <P CLASS="western">L&aelig;ses med</P>
      </TH>
    </TR>
  </THEAD>
  <TBODY>
    <TR VALIGN=TOP>
      <TD>
        <P CLASS="western">text</P>
      </TD>
      <TD>
        <P CLASS="western">String</P>
      </TD>
      <TD>
        <P CLASS="western">setText(String t)</P>
      </TD>
      <TD>
        <P CLASS="western">getText()</P>
      </TD>
    </TR>
    <TR VALIGN=TOP>
      <TD>
        <P CLASS="western">editable</P>
      </TD>
      <TD>
        <P CLASS="western">boolean</P>
      </TD>
      <TD>
        <P CLASS="western">setEditable(boolean rediger)</P>
      </TD>
      <TD>
        <P CLASS="western">isEditable()</P>
      </TD>
    </TR>
    <TR VALIGN=TOP>
      <TD>
        <P CLASS="western">columns</P>
      </TD>
      <TD>
        <P CLASS="western">int</P>
      </TD>
      <TD>
        <P CLASS="western">setColumns(int bredde)</P>
      </TD>
      <TD>
        <P CLASS="western">getColumns()</P>
      </TD>
    </TR>
    <TR VALIGN=TOP>
      <TD>
        <P CLASS="western">echoChar</P>
      </TD>
      <TD>
        <P CLASS="western">char</P>
      </TD>
      <TD>
        <P CLASS="western">setEchoChar(char tegn)</P>
      </TD>
      <TD>
        <P CLASS="western">getEchoChar()</P>
      </TD>
    </TR>
  </TBODY>
</TABLE>
<H3 CLASS="western">11.2.5 <a name='afsn11.2.5'></a>TextArea</H3>
<P CLASS="western"><IMG SRC="bog12_html_19becd6.png" NAME="Grafik12" ALIGN=LEFT BORDER=0><BR CLEAR=LEFT>Et
indtastningsfelt p&aring; flere linjer.</P>
<P CLASS="western">Egenskaberne <I>text, rows</I><SPAN STYLE="font-style: normal">
og </SPAN><I>columns</I> angiver, hvad der st&aring;r i feltet, hhv.
bredde og h&oslash;jde. 
</P>
<TABLE BORDER=0 CELLPADDING=2 CELLSPACING=0>
  <COL*>
  <COL*>
  <COL*>
  <COL*>
  <THEAD>
    <TR VALIGN=TOP>
      <TH>
        <P CLASS="western">Egenskab</P>
      </TH>
      <TH>
        <P CLASS="western">Type</P>
      </TH>
      <TH>
        <P CLASS="western">S&aelig;ttes med</P>
      </TH>
      <TH>
        <P CLASS="western">L&aelig;ses med</P>
      </TH>
    </TR>
  </THEAD>
  <TBODY>
    <TR VALIGN=TOP>
      <TD>
        <P CLASS="western">text</P>
      </TD>
      <TD>
        <P CLASS="western">String</P>
      </TD>
      <TD>
        <P CLASS="western">setText(String t)</P>
      </TD>
      <TD>
        <P CLASS="western">getText()</P>
      </TD>
    </TR>
    <TR VALIGN=TOP>
      <TD>
        <P CLASS="western">editable</P>
      </TD>
      <TD>
        <P CLASS="western">boolean</P>
      </TD>
      <TD>
        <P CLASS="western">setEditable(boolean rediger)</P>
      </TD>
      <TD>
        <P CLASS="western">isEditable()</P>
      </TD>
    </TR>
    <TR VALIGN=TOP>
      <TD>
        <P CLASS="western">columns</P>
      </TD>
      <TD>
        <P CLASS="western">int</P>
      </TD>
      <TD>
        <P CLASS="western">setColumns(int bredde)</P>
      </TD>
      <TD>
        <P CLASS="western">getColumns()</P>
      </TD>
    </TR>
    <TR VALIGN=TOP>
      <TD>
        <P CLASS="western">rows</P>
      </TD>
      <TD>
        <P CLASS="western">int</P>
      </TD>
      <TD>
        <P CLASS="western">setRows(int h&oslash;jde)</P>
      </TD>
      <TD>
        <P CLASS="western">getRows()</P>
      </TD>
    </TR>
  </TBODY>
</TABLE>
<P CLASS="western">TextField og TextArea har en del egenskaber til
f&aelig;lles og disse f&aelig;llestr&aelig;k ligger i superklassen
TextComponent (se klassediagrammet).</P>
<H3 CLASS="western">11.2.6 <a name='afsn11.2.6'></a>Label</H3>
<P CLASS="western"><IMG SRC="bog12_html_68b483e3.png" NAME="Grafik26" ALIGN=LEFT BORDER=0><BR CLEAR=LEFT>En
etikette, der viser en tekst (som brugeren ikke kan redigere i). 
</P>
<P CLASS="western">Egenskaben <I>text</I> angiver, hvad der st&aring;r
i feltet. 
</P>
<TABLE BORDER=0 CELLPADDING=2 CELLSPACING=0>
  <COL*>
  <COL*>
  <COL*>
  <COL*>
  <THEAD>
    <TR VALIGN=TOP>
      <TH>
        <P CLASS="western">Egenskab</P>
      </TH>
      <TH>
        <P CLASS="western">Type</P>
      </TH>
      <TH>
        <P CLASS="western">S&aelig;ttes med</P>
      </TH>
      <TH>
        <P CLASS="western">L&aelig;ses med</P>
      </TH>
    </TR>
  </THEAD>
  <TBODY>
    <TR VALIGN=TOP>
      <TD>
        <P CLASS="western">text</P>
      </TD>
      <TD>
        <P CLASS="western">String</P>
      </TD>
      <TD>
        <P CLASS="western">setText(String t)</P>
      </TD>
      <TD>
        <P CLASS="western">GetText()</P>
      </TD>
    </TR>
  </TBODY>
</TABLE>

<H3 CLASS="western" STYLE="">11.2.7 <a name='afsn11.2.7'></a>List</H3>
<P CLASS="western"><IMG SRC="bog12_html_m5c846ed3.png" NAME="Grafik8" ALIGN=LEFT BORDER=0><BR CLEAR=LEFT>En
menu, hvor flere af indgangene kan ses samtidigt og hvor man kan
v&aelig;lge en eller flere elementer. Brug metoden add(String
elementnavn) til at tilf&oslash;je indgange. 
</P>
<P CLASS="western">Med isIndexSelected(int index) unders&oslash;ger
man, om en indgang er valgt. 
</P>
<P CLASS="western">Egenskaberne <I>rows</I><SPAN STYLE="font-style: normal">
og </SPAN><I>multipleMode</I> angiver, hvad h&oslash;jden er og om
man kan v&aelig;lge flere indgange samtidigt. 
</P>
<TABLE BORDER=0 CELLPADDING=2 CELLSPACING=0>
  <COL*>
  <COL*>
  <COL*>
  <COL*>
  <THEAD>
    <TR VALIGN=TOP>
      <TH>
        <P CLASS="western">Egenskab</P>
      </TH>
      <TH>
        <P CLASS="western">Type</P>
      </TH>
      <TH>
        <P CLASS="western">S&aelig;ttes med</P>
      </TH>
      <TH>
        <P CLASS="western">L&aelig;ses med</P>
      </TH>
    </TR>
  </THEAD>
  <TBODY>
    <TR VALIGN=TOP>
      <TD>
        <P CLASS="western">rows</P>
      </TD>
      <TD>
        <P CLASS="western">int</P>
      </TD>
      <TD>
        <P CLASS="western">setRows(int h&oslash;jde)</P>
      </TD>
      <TD>
        <P CLASS="western">getRows()</P>
      </TD>
    </TR>
    <TR VALIGN=TOP>
      <TD>
        <P CLASS="western">multipleMode</P>
      </TD>
      <TD>
        <P CLASS="western">boolean</P>
      </TD>
      <TD>
        <P CLASS="western">setMultipleMode(boolean m)</P>
      </TD>
      <TD>
        <P CLASS="western">getMultipleMode()</P>
      </TD>
    </TR>
  </TBODY>
</TABLE>
<H3 CLASS="western">11.2.8 <a name='afsn11.2.8'></a>Canvas</H3>
<P CLASS="western">Et tegne-omr&aring;de. Canvas er en anelse
besv&aelig;rlig, idet man skal nedarve fra klassen og implementere
paint(Graphics g) for at kunne tegne noget.</P>
<P CLASS="western">En lettere (men ikke n&oslash;dvendigvis altid
smartere) m&aring;de er som sagt at definere paint()-metoden direkte
i appletten/vinduet, som vi har gjort tidligere.</P>
<H2 CLASS="western">11.3 <a name='afsn11.3'></a>Eksempel</SPAN></H2>
<P CLASS="western">Herunder et eksempel (genereret med JBuilder), der
viser komponenterne omtalt i forrige afsnit. 
</P>
<P ALIGN=CENTER STYLE="margin-top: 0.11cm; margin-bottom: 0.11cm"><IMG SRC="bog12_html_m6c15f450.png" NAME="Grafik9" ALIGN=BOTTOM BORDER=0></P>
<P CLASS="western" ALIGN=LEFT>P&aring; billedet ses det resulterende
sk&aelig;rmbillede under Windows (sidst i kapitlet ses, hvordan det
ser ud under Linux).</P>

<PRE CLASS="kode-western" STYLE="text-align: left">public class VisGrafiskeKomponenter
{
  public static void main(String[] arg)
  {
    GrafiskeKomponenter vindue = new GrafiskeKomponenter();
    vindue.setSize(700,300);
    vindue.setVisible(true);
  }
}</PRE>

<PRE CLASS="kode-western" STYLE="">import java.awt.*;

public class GrafiskeKomponenter extends Frame
{
<I>  // opret alle komponenterne og husk dem i nogle objektvariabler</I>
  Button button1 = new Button();
  Checkbox checkbox1 = new Checkbox();
  Checkbox checkbox2 = new Checkbox();
  Checkbox checkbox3 = new Checkbox();
  Checkbox checkbox4 = new Checkbox();
  Checkbox checkbox5 = new Checkbox();
  CheckboxGroup checkboxGroup1 = new CheckboxGroup();
  Choice choice1 = new Choice();
  TextField textField1 = new TextField();
  TextArea textArea1 = new TextArea();
  List list1 = new List();
  Label label1 = new Label();

  FlowLayout flowLayout1 = new FlowLayout(); <I>// layout-manager (se senere)</I>

  public GrafiskeKomponenter() {
    try {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }

  private void jbInit() throws Exception {
    button1.setLabel(&quot;OK&quot;);

    checkbox1.setLabel(&quot;En&quot;);     <I>// S&aelig;t afkrydsningsfelternes navne</I>
    checkbox2.setLabel(&quot;To&quot;);
    checkbox3.setLabel(&quot;Tre&quot;);

    checkbox4.setLabel(&quot;Radio1&quot;); <I>// S&aelig;t radioknappernes navne og</I>
    checkbox5.setLabel(&quot;Radio2&quot;);
    checkbox4.setCheckboxGroup(checkboxGroup1);<I> // gruppen de tilh&oslash;rer</I>
    checkbox5.setCheckboxGroup(checkboxGroup1);
    checkboxGroup1.setSelectedCheckbox(checkbox4);

    choice1.add(&quot;Choice R&oslash;d&quot;);
    choice1.add(&quot;Choice Gr&oslash;n&quot;);
    choice1.add(&quot;Choice Bl&aring;&quot;);

    textField1.setColumns(10);
    textField1.setText(&quot;Et TextField&quot;);

    textArea1.setColumns(15);
    textArea1.setRows(5);
    textArea1.setText(&quot;Et TextArea&quot;);

    label1.setText(&quot;En Label&quot;);

    list1.add(&quot;List R&oslash;d&quot;);
    list1.add(&quot;List Gr&oslash;n&quot;);
    list1.add(&quot;List Bl&aring;&quot;);

    this.setLayout(flowLayout1);<I>// s&aelig;t layout-manager (se senere)</I>

    this.add(button1, null);    <I>// til sidst skal komponenterne f&oslash;jes</I>
    this.add(checkbox1, null);  <I>// til containeren (se senere)</I>
    this.add(checkbox2, null);
    this.add(checkbox3, null);
    this.add(checkbox4, null);
    this.add(checkbox5, null);
    this.add(choice1, null);
    this.add(textArea1, null);
    this.add(textField1, null);
    this.add(label1, null);
    this.add(list1, null);
  }
}</PRE>
<H2 CLASS="western">11.4 <a name='afsn11.4'></a>Containere</SPAN></H2>
<P CLASS="western">En <I>container</I> er beregnet til at indeholde
komponenter. De arver alle fra Container-klassen og har alle en
s&aring;kaldt <I>layout-manager</I><SPAN STYLE="font-style: normal">
tilknyttet, der bestemmer, hvor og med hvilken st&oslash;rrelse
komponenterne skal vises i containeren.</SPAN> 
</P>
<P CLASS="western">For at en komponent bliver vist, skal den tilf&oslash;jes
en container. I eksemplet ovenfor er vinduet den container,
komponenterne bliver tilf&oslash;jet og derfor st&aring;r der sidst i
initialiseringen:</P>
<PRE CLASS="kode-western">    this.add(button1, null);</PRE><H3 CLASS="western" ALIGN=LEFT>
11.4.1 <a name='afsn11.4.1'></a>Panel</H3>
<P CLASS="western" ALIGN=LEFT>Et panel er den simpleste og oftest
brugte container. Den indeholder simpelt hen komponenterne (i henhold
til layout-manageren).</P>
<H3 CLASS="western" ALIGN=LEFT>11.4.2 <a name='afsn11.4.2'></a>Applet</H3>
<P CLASS="western" ALIGN=LEFT>En applet er et udvidet panel, der er
beregnet til at blive vist i en netl&aelig;ser. L&aelig;s <a href='kapitel10.jsp'>kapitel 10</a>,
Appletter for mere information om denne klasse.</P>
<H3 CLASS="western" ALIGN=LEFT>11.4.3 <a name='afsn11.4.3'></a>Window</H3>
<P CLASS="western" ALIGN=LEFT>Window repr&aelig;senterer et bart
vindue uden en titellinje eller lukkeknap &oslash;verst. Det bruges
meget sj&aelig;ldent direkte. Man bruger i stedet arvingerne Frame og
Dialog.</P>
<H3 CLASS="western" ALIGN=LEFT>11.4.4 <a name='afsn11.4.4'></a>Frame</H3>
<P CLASS="western" ALIGN=LEFT>En Frame er den simpleste og oftest
brugte m&aring;de at definere et &quot;normalt&quot; vindue med en
titel. L&aelig;s <a href='kapitel9.jsp'>kapitel 9</a>, Grafiske programmer for mere information
om denne klasse.</P>
<H3 CLASS="western">11.4.5 <a name='afsn11.4.5'></a>Dialog</H3>
<P CLASS="western">Dialog bruges til dialog-bokse, vinduer, der
dukker op med et eller andet sp&oslash;rgsm&aring;l, som skal
besvares, f&oslash;r man kan g&aring; videre. Egenskaben <I>modal</I>
angiver, om dialog-boksen er modal, dvs. om man skal lukke den, f&oslash;r
man kan f&aring; adgang til ejer-vinduet. Den s&aelig;ttes med
setModal(boolean m) og afl&aelig;ses med isModal(). Er vinduet modalt
vil et kald til setVisible(true) vente, indtil brugeren har udfyldt
og lukket dialog-boksen igen.</P>
<H2 CLASS="western">11.5 <a name='afsn11.5'></a>Relationer mellem klasserne</SPAN></H2>
<P CLASS="western">Herunder ses klassediagrammet for nogle af
komponenterne og containerne. 
</P>
<P CLASS="western"><IMG SRC="bog12_html_1968bd02.gif" NAME="Objekt27" ALIGN=MIDDLE></P>
<P CLASS="western">De hule pile ( 
<IMG SRC="bog12_html_m5a719e64.gif" ALIGN=BOTTOM> ) repr&aelig;senterer
<B>er-en</B>-relationer (dvs. nedarvning). De andre pile ( 
<IMG SRC="bog12_html_3e6bba03.gif" ALIGN=BOTTOM> ), mellem Container
og Component og mellem CheckboxGroup og Checkbox, repr&aelig;senterer
<B>har</B>-relationer (dvs. at et objekt har en reference til et
andet objekt, evt. &quot;ejer&quot; objektet).</P>
<P CLASS="western" ALIGN=LEFT STYLE="">Bem&aelig;rk,
at Container selv arver fra Component, s&aring; en Container kan i
sig selv bruges som en komponent. Det er relevant for Panel og
ScrollPane, der er beregnet til at blive placeret inden i andre
containere.</P>
<H2 CLASS="western">11.6 <a name='afsn11.6'></a>Layout-managere</SPAN></H2>
<P CLASS="western">En layout-manager styrer layoutet af komponenterne
p&aring; et Panel eller en anden container. Alle containere har
egenskaben <I>layout</I>, der kan s&aelig;ttes med metoden
setLayout(Layout l).</P>
<H3 CLASS="western">11.6.1 <a name='afsn11.6.1'></a>Ingen styring (null-layout)</H3>
<P CLASS="western">I udviklingsfasen er det mest bekvemt at s&aelig;tte
layout-manageren til null, der tillader udvikleren at s&aelig;tte
komponenterne, som han vil p&aring; en hvilken som helst
(x,y)-position og med en hvilken som helst h&oslash;jde og bredde.
Koden ser s&aring;ledes ud:</P>
<PRE CLASS="kode-western">    this.setLayout(null);                              <I>// s&aelig;t null-layout</I>
    this.add(button1, null);                           <I>// tilf&oslash;j knap</I>
    button1.setBounds(new Rectangle(231, 60, 91, 32)); <I>// s&aelig;t position/st&oslash;rrelse</I></PRE><P CLASS="western">
null-layout tager slet ikke h&oslash;jde for vinduets st&oslash;rrelse,
s&aring; hvis vinduet bliver for lille, vil nogle af komponenterne
ikke blive vist. N&aring;r programmet er ved at v&aelig;re f&aelig;rdigt,
b&oslash;r man derfor &aelig;ndre programmet til at bruge en
layout-manager, der kan styre komponenternes st&oslash;rrelse og
indbyrdes placering ud fra deres behov.</P>
<H3 CLASS="western">11.6.2 <a name='afsn11.6.2'></a>FlowLayout</H3>
<P CLASS="western" ALIGN=LEFT>FlowLayout placerer komponenterne
ligesom bogstaver: &Oslash;verst fra venstre mod h&oslash;jre og p&aring;
en ny linje nedenunder, n&aring;r der ikke er mere plads.</P>
<P ALIGN=CENTER STYLE="margin-top: 0.11cm; margin-bottom: 0.11cm"><IMG SRC="bog12_html_4a250352.png" NAME="Grafik7" ALIGN=BOTTOM BORDER=0></P>
<P CLASS="western" ALIGN=LEFT>Angiver man ikke nogen layout-manager i
et panel/applet, vil FlowLayout blive brugt.</P>
<P CLASS="western" ALIGN=LEFT>I eksemplet GrafiskeKomponenter ovenfor
blev FlowLayout brugt:</P>
<PRE CLASS="kode-western">    this.setLayout(new FlowLayout());
    this.add(button1, null);</PRE><H3 CLASS="western">
11.6.3 <a name='afsn11.6.3'></a>BorderLayout</H3>
<P CLASS="western" ALIGN=LEFT>BorderLayout tager h&oslash;jde for
vinduets st&oslash;rrelse og tilpasser komponenternes st&oslash;rrelse
efter den tilg&aelig;ngelige plads. Komponenterne kan placeres
p&aring; 5 mulige positioner, nemlig NORTH, SOUTH, EAST, WEST og
CENTER.</P>
<P ALIGN=CENTER STYLE="margin-top: 0.11cm; margin-bottom: 0.11cm"><IMG SRC="bog12_html_7b029000.png" NAME="Grafik10" ALIGN=BOTTOM BORDER=0></P>
<P CLASS="western" ALIGN=LEFT>Den mest almindelige m&aring;de at lave
det grafiske layout af et sk&aelig;rmbillede er med BorderLayout.
I de omr&aring;der, hvor man &oslash;nsker at placere flere
komponenter, s&aelig;tter man f&oslash;rst et Panel og komponenterne
tilf&oslash;jes s&aring; panelet.</P>
<P CLASS="western" ALIGN=LEFT STYLE="">Angiver
man ikke nogen layout-manager i et vindue, vil BorderLayout blive
brugt (i eksemplet nedenfor kunne de to linjer omkring BorderLayout
strengt taget fjernes).</P>
<PRE CLASS="kode-western" STYLE="text-align: left">import java.awt.*;

public class VindueMedBorderLayout extends Frame
{
  Button button1 = new Button();
  Button button2 = new Button();
  Button button3 = new Button();
  Button button4 = new Button();
  Button button5 = new Button();

<B>  BorderLayout borderLayout1 = new BorderLayout();</B>

  public VindueMedBorderLayout() {
    try {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }

  private void jbInit() throws Exception {
    button1.setLabel(&quot;NORTH&quot;);
    button2.setLabel(&quot;SOUTH&quot;);
    button3.setLabel(&quot;EAST&quot;);
    button4.setLabel(&quot;WEST&quot;);
    button5.setLabel(&quot;CENTER&quot;);

<B>    this.setLayout(borderLayout1);</B>

<B>    this.add(button1, BorderLayout.NORTH);</B>
<B>    this.add(button2, BorderLayout.SOUTH);</B>
<B>    this.add(button3, BorderLayout.EAST);</B>
<B>    this.add(button4, BorderLayout.WEST);</B>
<B>    this.add(button5, BorderLayout.CENTER);</B>
  }
}</PRE><P CLASS="western" ALIGN=LEFT>
Man s&aelig;tter alts&aring; f&oslash;rst layoutet ved at kalde
setLayout() med et BorderLayout-objekt. Derefter kan add() kaldes med
komponenterne og deres placering p&aring; borderlayoutet.</P>
<P CLASS="western" ALIGN=LEFT>Bem&aelig;rk, at n&aring;r man bruger
en layout-manager, b&oslash;r man lade den afg&oslash;re vinduets
st&oslash;rrelse ud fra komponenternes behov, ved at kalde pack() i
stedet for setSize() p&aring; vinduet. Denne metode pakker
komponenterne i vinduet optimalt og s&aelig;tter vinduesst&oslash;rrelsen
passende.</P>
<PRE CLASS="kode-western" STYLE="text-align: left">public class VisVindueMedBorderLayout
{
  public static void main(String[] arg)
  {
    VindueMedBorderLayout vindue = new VindueMedBorderLayout();
    <B>vindue.pack()</B>;<I>// s&aelig;tter en rimelig vinduesst&oslash;rrelse (i stedet for setSize())</I>
    vindue.setVisible(true);
  }
}</PRE><H3 CLASS="western">
11.6.4 <a name='afsn11.6.4'></a>GridBagLayout</H3>
<P CLASS="western">En anden m&aring;de at lave layout er med
GridBagLayout, som l&aelig;gger komponenterne efter et usynligt
gitter. Hver komponent kan fylde en eller flere celler i h&oslash;jden
eller bredden.</P>
<P ALIGN=CENTER STYLE="margin-top: 0.11cm; margin-bottom: 0.11cm"><IMG SRC="bog12_html_m2c9a4d37.png" NAME="Grafik33" ALIGN=BOTTOM BORDER=0></P>
<PRE CLASS="kode-western">import java.awt.*;

public class VindueMedGridBagLayout extends Frame
{
  GridBagLayout gridBagLayout1 = new GridBagLayout();
  Button   knap1 = new Button();
  Button   knap2 = new Button();
  Button   knap3 = new Button();
  Button   knap4 = new Button();
  Button   knap5 = new Button();
  Checkbox chkH&oslash; = new Checkbox();
  Checkbox chkVe = new Checkbox();
  Checkbox chkCe = new Checkbox();
  TextArea tekst = new TextArea();

  public VindueMedGridBagLayout() {
    try {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }

  private void jbInit() throws Exception {
    knap1.setLabel(&quot;knap1 (p&aring; 3x1 celler)&quot;);
    knap2.setLabel(&quot;knap2 (1x2)&quot;);
    knap3.setLabel(&quot;knap3 (p&aring; 1x1 celle)&quot;);
    knap4.setLabel(&quot;knap4 (1x1)&quot;);
    knap5.setLabel(&quot;knap5 (1x1)&quot;);
    chkH&oslash;.setLabel(&quot;H&oslash;jre&quot;);
    chkVe.setLabel(&quot;Venstre&quot;);
    chkCe.setLabel(&quot;Centreret&quot;);
    tekst.setColumns(15);
    tekst.setRows(2);
    tekst.setText(&quot;Tekstfelt (3x3 celler)&quot;);

    <B>this.setLayout(gridBagLayout1);</B>

<I>    // til sidst skal komponenterne f&oslash;jes til containeren</I>
<B>    this.add(knap1, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, </B>
<B>    GridBagConstraints.CENTER,GridBagConstraints.BOTH,new Insets(0,0,0,0),0,0));</B>
    this.add(knap2, new GridBagConstraints(3, 0, 1, 2, 0.0, 0.0,
    GridBagConstraints.CENTER,GridBagConstraints.BOTH,new Insets(0,0,0,0),0,0));
    this.add(knap3, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0,
    GridBagConstraints.CENTER,GridBagConstraints.BOTH,new Insets(0,0,0,0),0,0));
    this.add(knap4, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0,
    GridBagConstraints.CENTER,GridBagConstraints.BOTH,new Insets(0,0,0,0),0,0));
    this.add(knap5, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0,
    GridBagConstraints.CENTER,GridBagConstraints.BOTH,new Insets(0,0,0,0),0,0));
    this.add(chkH&oslash;, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0,
    GridBagConstraints.EAST,  GridBagConstraints.NONE,new Insets(0,0,0,0),0,0));
    this.add(chkVe, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0,
    GridBagConstraints.WEST,  GridBagConstraints.NONE,new Insets(0,0,0,0),0,0));
    this.add(chkCe, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0,
    GridBagConstraints.CENTER,GridBagConstraints.NONE,new Insets(0,0,0,0),0,0));
    this.add(tekst, new GridBagConstraints(1, 2, 3, 3, 0.0, 0.0,
    GridBagConstraints.CENTER,GridBagConstraints.BOTH,new Insets(0,0,0,0),0,0));
  }
}</PRE><P CLASS="western">
N&aring;r en komponent tilf&oslash;jes, angives i et
GridBagConstraints-objekt:</P>
<UL>
  <LI><P CLASS="western">Komponentens position (cellekolonne og
  -r&aelig;kke)</P>
  <LI><P CLASS="western">Komponentens sp&aelig;ndvidde i h&oslash;jde
  og bredde 
  </P>
  <LI><P CLASS="western">V&aelig;gt i h&oslash;jde og bredde
  (komponenter med st&oslash;rst v&aelig;rdi f&aring;r mest af
  eventuel overskydende plads)</P>
  <LI><P CLASS="western">Justering i tilf&aelig;lde af overskydende
  plads (CENTER, EAST, WEST, NORTHEAST, ...)</P>
  <LI><P CLASS="western">Om komponenten skal str&aelig;kkes til at
  fylde overskydende plads (BOTH, NONE, HORIZONTAL, VERTICAL)</P>
  <LI><P CLASS="western">Til sidst nogle parametre til inds&aelig;ttelse
  af ekstra plads.</P>
</UL>
<P CLASS="western">Her er koden, der viser vinduet.</P>
<PRE CLASS="kode-western">public class VisVindueMedGridBagLayout
{
  public static void main(String[] arg)
  {
    VindueMedGridBagLayout vindue = new VindueMedGridBagLayout();
    vindue.pack();
    vindue.setVisible(true);
  }
}</PRE><H2 CLASS="western">
11.7 <a name='afsn11.7'></a>Menuer</SPAN></H2>
<P CLASS="western" STYLE="; ">
Menuer med rullegardiner er relativt enkle at lave. Herunder ses
brudstykkerne af den kode, der skal til, for at lave menuerne vist p&aring;
figuren til h&oslash;jre.</P>
<PRE CLASS="kode-western" STYLE=""><IMG SRC="bog12_html_m7a71da04.png" NAME="Graphic3" ALIGN=RIGHT BORDER=0>  MenuBar menuBar1 = new MenuBar();

  Menu     menuFil         = new Menu();
  MenuItem menuItem&Aring;bn     = new MenuItem();
  MenuItem menuItemAfslut  = new MenuItem();

  Menu     menuHj&aelig;lp       = new Menu();

  <I>... i f.eks jbInit() kunne der st&aring;:</I>

    this.setMenuBar(menuBar1);

    menuFil.setLabel(&quot;Fil&quot;);
    menuItem&Aring;bn.setLabel(&quot;&Aring;bn&quot;);
    menuItemAfslut.setLabel(&quot;Afslut&quot;);
    menuFil.add(menuItem&Aring;bn);
    menuFil.add(menuItemAfslut);
    menuBar1.add(menuFil);

    menuHj&aelig;lp.setLabel(&quot;Hj&aelig;lp&quot;);
    menuBar1.add(menuHj&aelig;lp);</PRE><P CLASS="western" STYLE="">
For at fange, n&aring;r brugeren v&aelig;lger et menupunkt, skal man
lytte efter actionPerformed, ligesom med Button-klassen (det blev
diskuteret i <a href='kapitel11.jsp#afsn11.1.1'>afsnit 11.1.1</a>).</P>
<H2 CLASS="western">11.8 <a name='afsn11.8'></a>Test dig selv</SPAN></H2>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_OOP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/OOP3/kapitel11.jsp#afsn11.8">
  <input type='checkbox' name='vis' value='11.8'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='11.8'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H2 CLASS="western">11.9 <a name='afsn11.9'></a>Resum&eacute;</SPAN></H2>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_OOP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/OOP3/kapitel11.jsp#afsn11.9">
  <input type='checkbox' name='vis' value='11.9'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='11.9'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H2 CLASS="western" STYLE="">11.10 <a name='afsn11.10'></a>Avanceret</SPAN></H2>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_OOP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/OOP3/kapitel11.jsp#afsn11.10">
  <input type='checkbox' name='vis' value='11.10'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='11.10'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western">11.10.1 <a name='afsn11.10.1'></a>AWT-komponenter p&aring; andre platforme</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_OOP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/OOP3/kapitel11.jsp#afsn11.10.1">
  <input type='checkbox' name='vis' value='11.10.1'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='11.10.1'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western">11.10.2 <a name='afsn11.10.2'></a>Swing-komponenter</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_OOP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/OOP3/kapitel11.jsp#afsn11.10.2">
  <input type='checkbox' name='vis' value='11.10.2'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='11.10.2'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  

<a href='http://javabog.dk/'>javabog.dk</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel10.jsp'>&lt;&lt; forrige</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='indhold.jsp'>indhold</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel12.jsp'>n&aelig;ste &gt;&gt;</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kode/'>programeksempler</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='../index_OOP.html'>om bogen</a>
<hr>
<font size=-2>http://javabog.dk/ - <b></b> af Jacob Nordfalk.
<br>
  Licens og kopiering under <a href='http://www.linuxbog.dk/licens.html'>&Aring;ben Dokumentlicens</a> (&Aring;DL)
  hvor intet andet er nvnt (82% af vrket).
</font>
<br>
nsker du at se de sidste 18% af dette vrk (199974 tegn)
skal du kbe bogen. S fr du pne figurer og layout, stikordsregister og en trykt bog med i kbet.
<!-- netlser: Wget/1.10, autoHent: true  -->
     

</body>
</html>
